 ; Ŀ
 ;   T3 - split a line of text into a stack of shorter lines.              
 ;   Copyright 2000, 2004, 2005 by Rocket Software Ltd.                    
 ;   There are no printers which can apply gold leaf.                      
 ; 

 ; Ŀ
 ;   Lsplit: divide a line in half at the space closest to the middle.     
 ;   Arguments: Str, A string.  Oddly enough.                              
 ;   Returns a list of two strings.  Oddly enough.                         
 ; 
 (DEFUN LSPLIT (str / pos0 pos1 done more less pos)
 ; Ŀ
 ;   Remove leading and trailing spaces.                                   
 ; 
  (while (and (/= str "") (= (substr str 1 1) " "))
         (setq str (substr str 2)))
  (while (and (/= str "") (= (substr str (setq len (strlen str))) " "))
         (setq str (substr str 1 (1- len))))
 ; Ŀ
 ;   Find the space.                                                       
 ; 
  (if (/= str "")
      (progn
           (setq pos0 (setq pos1 (/ len 2)))    ; both INTs, rounds off
           (while (null done)
                  (if (= pos0 0)
                      (setq done t)
                      (if (setq less (= (substr str pos0 1) " "))
                          (setq done t)
                          (setq pos0 (1- pos0))))
                  (if (> pos1 len)
                      (setq done t)
                      (if (setq more (= (substr str pos1 1) " "))
                          (setq done t)
                          (setq pos1 (1+ pos1)))))))
 ; Ŀ
 ;   Return the split string.                                              
 ; 
  (if (setq pos (cond (less pos0) (more pos1) (T ())))
      (list (substr str 1 (1- pos)) (substr str (1+ pos)))
      (list str)))
 ; Ŀ
 ;   Lsplit end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; This isn't the best algorithm.  Suppose that we have a list of six
 ; substrings (1 2 3 4 5 6) and want to make it into two.
 ; Combining shortest substrings gives (12 34 56).  Then the program will
 ; keep on, giving either (1234 56) or (12 3456) when what we want is
 ; (123 456).
 ; Maybe searching for spaces at the calculated break points would be better.
 ; Although this is a special case - if we want three strings then this would
 ; be ok.
 ; Maybe calculate the number of substrings and ...
 ; For two, start at the middle.  But we are not always dealing with
 ; substrings of the same length.
 ; Maybe a post-adjuster which tries to move things around when Txop is
 ; finished.
 ; Or a function which can compare two strings and move substrings from one
 ; to another until they are as close as possible to the same length.
 ; Will this work?  Or is too much foresight necessary?
 ; How do we do this?  Probably several methods.
 ; Two is a special case.  Can it be generalised?  Combine into two strings,
 ; then shuffle substrings back and forth till the difference between the two
 ; doesn't decrease any more.  Maybe.
 ; Ŀ
 ;   Txop: divide a string at spaces into a given number of substrings.    
 ;   Get the two shortest adjacent strings in the list, join them.         
 ;   Repeat until there are the desired number of strings.                 
 ;   Arguments: Idealn, the desired number of substrings.                  
 ;              Str, the string to divide up.                              
 ;   Returns a list of strings.                                            
 ;   Calls Splat and Txopp.                                                
 ; 
 (DEFUN TXOP (idealn str / strlst lislen)
 ; Ŀ
 ;   Call Splat to make the string into a list of strings.                 
 ; 
  (setq strlst (splat " " str))
 ; Ŀ
 ;   While there are more than Idealn strings and the list has more than   
 ;   one member call Txopp to join the two shortest strings in the list.   
 ; 
  (while (and (setq lislen (length strlst))
              (> lislen idealn)
              (> lislen 1))
         (setq strlst (txopp strlst))
 ; (print strlst)
         )
 ; Ŀ
 ;   Return the new list.                                                  
 ; 
  strlst)
 ; Ŀ
 ;   Subroutine Txop end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Txopp.                                                     
 ;   Get the two shortest adjacent strings in a list, join them.           
 ;   Takes one argument, a list of strings.                                
 ;   Returns the modified list.                                            
 ;   Called by Txop.                                                       
 ; 
 (DEFUN TXOPP (strlst / num sub sub2 lenp minlen pos nulist)
 ; Ŀ
 ;   Find the shortest pair of adjacent strings.                           
 ;   Step through the list, checking the length of each pair against the   
 ;   saved shortest length and position, and replacing the saved l&p if    
 ;   the new ones are less.                                                
 ; 
  (setq num 0)
  (while (and (setq sub (nth num strlst)) (setq sub2 (nth (1+ num) strlst)))
         (setq lenp (+ (strlen sub) (strlen sub2)))
         (if (or (null minlen) (< lenp minlen))
             (progn
                  (setq minlen lenp)
                  (setq pos num)))
         (setq num (1+ num)))
 ; Ŀ
 ;   Now step through the list to the position of the shortest pair and    
 ;   strcat them together, rebuilding the list at the same time.           
 ; 
  (setq num 0)
  (while (setq sub (nth num strlst))
         (if (= pos num)
             (setq sub (strcat sub " " (nth (setq num (1+ num)) strlst))))
         (setq nulist (cons sub nulist))
         (setq num (1+ num)))
 (reverse nulist))
 ; Ŀ
 ;   Subroutine Txopp end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Veeb - add text strings below an existing one.             
 ;   Arguments: Enam, the existing text entity name.                       
 ;              Strlst, a list of strings.                                 
 ;   Calls its Granny, Returns nothing.                                    
 ; 
 (DEFUN VEEB (enam strlst / entt pa incr vdis rota num str num pb elast)
  (setq entt (entget enam))
  (setq pa (cdr (assoc 10 entt)))
  (setq incr (* 1.65 (cdr (assoc 40 entt))))
  (setq vdis incr)
  (setq rota (cdr (assoc 50 entt)))
  (setq str (car strlst))
  (entmod (subst (cons 1 str) (assoc 1 entt) entt))
  (setq num 1)
  (while (setq str (nth num strlst))
         (setq num (1+ num))
         (setq pb (polar pa (+ rota (* pi 1.5)) vdis))
         (command ".copy" enam "" pa pb)
         (setq elast (entlast))
         (setq entt (entget elast))
         (entmod (subst (cons 1 str) (assoc 1 entt) entt))
         (setq vdis (+ vdis incr)))
 (princ))
 ; Ŀ
 ;   Subroutine Veeb end.                                                  
 ; 

 ; Ŀ
 ;   T3.                                                                   
 ; 
 (DEFUN C:T3 (/ *error* enam entt str listrs len nump)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun t*error* (shk)
   (if snapp (setvar "snapmode" snapp))
   (command "undo" "end"))
 ; Ŀ
 ;   Get a text string.                                                    
 ; 
  (if (and (setq enam (entsel "\nText: "))
           (setq enam (car enam))
           (setq entt (entget enam))
           (setq str (cdr (assoc 1 entt))))
      (progn
 ; Ŀ
 ;   Count the number of substrings, save them as a list.                  
 ; 
           (setq listrs (splat " " str))
           (setq len (length listrs))
 ; Ŀ
 ;   See how many text strings are desired.                                
 ; 
           (if (/= (type snum) 'INT) (setq snum 3))
           (initget 128 "All")
           (setq nump (getint (strcat "\nNumber of strings or All ("
                                      (itoa len) ") <"
                                      (itoa snum) ">: ")))
           (if nump (setq snum nump))
 ; Ŀ
 ;   We already have the string as a list of all substrings: Listrs.       
 ;   If we want it split into some other number then get Txop to make a    
 ;   new Listrs list.                                                      
 ;   If (cond) we want it split in two, use Lsplit which does a better     
 ;   job of that.                                                          
 ; 
           (cond ((= snum 2)
                  (setq listrs (lsplit str)))
                 ((/= snum "All")
                  (setq listrs (txop snum str))))
 ; Ŀ
 ;   Call veeb to manufacture the stack of new text entities.              
 ; 
           (veeb enam listrs)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))